
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;

map<int, vector<int>> globalCitiesRoads;
int globalN;

vector<int> makeCycle (bitset<100000> visitedCities, int visitedCitiesSize, int startCity, vector<int> road) {
    road.push_back(startCity);
    visitedCities[startCity] = 1;
    visitedCitiesSize++;

    if (visitedCitiesSize == globalN) {
        if (find(globalCitiesRoads[startCity].begin(), globalCitiesRoads[startCity].end(), 1) != globalCitiesRoads[startCity].end()) {
            road.push_back(1);
            return road;
        }
        return { -1 };
    }

    for (int city : globalCitiesRoads[startCity]) {
        if (!visitedCities[city]) {
            vector<int> cycle = makeCycle(visitedCities, visitedCitiesSize, city, road);
            if (cycle[0] != -1) {
                return cycle;
            }
            cycle = {};
        }
    }
    road.clear();
    visitedCities.reset();

    return { -1 };
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    
    int n, m;
    cin >> n >> m;

    globalN = n;

    map<int, vector<int>> citiesRoads;

    vector<vector<int>> roads(m);

    int j = 0;

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        citiesRoads[a].push_back(b);
    }

    globalCitiesRoads = citiesRoads;

    bitset<100000> visitedCities;
    vector<int> result = {-1};
    for (int city : citiesRoads[1]) {
        vector<int> cycle = makeCycle(visitedCities, 0, 1, {});
        if (cycle[0] != -1) {
            result = cycle;
            break;
        }
    }

    if (result[0] == -1) {
        printf("NO");
        return 0;
    }
    printf("YES\n");
    for (int c : result) {
        printf("%i ", c);
    }

    
    
}
